/**
 * Title: media-uploader-old.js
 *
 * Description: Defines JS for media uploader for WP version prior to 3.5.
 *
 * Please do not edit this file. This file is part of the Cyber Chimps Framework and all modifications
 * should be made in a child theme.
 *
 * @category Cyber Chimps Framework
 * @package  Framework
 * @since    1.0
 * @author   CyberChimps
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v3.0 (or later)
 * @link     http://www.cyberchimps.com/
 */

jQuery(document).ready(function () {

	// Save the original value
	var orig_send_to_editor = window.send_to_editor;

	// Call the uploader on click of upload button
	jQuery('.upload_image_button').click(function () {

		// Get reference to the parent.
		var parent = jQuery(this).parent();

		window.send_to_editor = function (html) {
			imgurl = jQuery('img', html).attr('src');
			parent.find('.upload_image_field').val(imgurl);
			tb_remove();

			// Reset the original value
			window.send_to_editor = orig_send_to_editor;
		}

		formfield = jQuery('#upload_image').attr('name');
		tb_show('', 'media-upload.php?type=image&amp;TB_iframe=true');

		return false;
	});
});